import java. awt. *;



public class NorthEastPanel extends Panel {



  // Buttons
  Button startButton,
         stopButton,
         resetButton;

  // Variablen fuer Layout der Buttons
  int distance;           // Abstand zwischen Buttons und Bilder
  int buttonsSpaceWidth;  // buttonsSpace- = Platzhalter fuer Buttons
  int buttonsSpaceHeight;

  int startButtonXPosition;
  int stopButtonXPosition;
  int resetButtonXPosition;
  int buttonsYPosition;

  int buttonsWidth;
  int buttonsHeight;

  // Thread, um den stopButton blicken zu lassen, wenn es auf Pause ist. 
  ButtonLabelThread stopButtonLabelThread;

  // Zeitzaehler, wenn in eine Pause ( String wird geschrieben ) gestoppt wird
  int timeCounter = 0;



  // Bilder
  Image clientImage_1,
        clientImage_2,
        serverImage;

  // Variablen fuer Layput der Bilder
  int imagesSpaceWidth;  // imagesSpace- = Platzhalter fuer Bilder
  int imagesSpaceHeight;

  int clientImageXPosition;
  int serverImageXPosition;
  int imagesYPosition;

  int imagesWidth;
  int imagesHeight;
  
  int distanceBetweenImages;
  int connectionLength; 

  // Um erst die Bilder zu laden
  MediaTracker tracker;



  // Koordinaten fur TCP Connection Linien
  int upperTCPConnectionLineXStart; 
  int upperTCPConnectionLineYStart; 
  
  int lowerTCPConnectionLineXStart; 
  int lowerTCPConnectionLineYStart; 
  
  // Parameter um das Packet zu zeichnen.
  int packetXStart;
  int packetYPosition;
  int packetWidth;
  int packetHeight;
  int actualPacketXPosition;
  int porcentage = 0;



  // Scrollbar fuer Steuerung der Schnelligkeit
  Scrollbar slider;



  // Variablen fuer die Steuerung der Fontgroesse der Strings
  boolean textFits;
  Font font;
  FontMetrics fontMetrics;
  int maxStringHeight;
  int maxStringWidth;



  // Steuert den ganzen Ablauf
  FlowControlThread flowControlThread;



  // Bedingungen fuer das Steuern des Ablaufs ( Schrittweise )
  boolean stopFlowControlThread = true;
  boolean stopLabelThread = true;
  boolean start = false;
  boolean reset = false;

  boolean firstTCPHandshakeToOpenFirstConnection = false;
  boolean secondTCPHandshakeToOpenFirstConnection = false;
  boolean thirdTCPHandshakeToOpenFirstConnection = false;
  boolean firstRequestReached = false;
  boolean firstResponseReached = false;
  boolean firstTCPHandshakeToCloseFirstConnection = false;
  boolean secondTCPHandshakeToCloseFirstConnection = false;
  boolean thirdTCPHandshakeToCloseFirstConnection = false;
  boolean string_1Removed = false;
  boolean string_2Removed = false;
  boolean string_3Removed = false;
  boolean string_4Removed = false;
  boolean string_5Removed = false;
  boolean string_6Removed = false;
  boolean string_7Removed = false;
  boolean string_8Removed = false;
  boolean string_9Removed = false;
  boolean string_10Removed = false;

  boolean firstTCPHandshakeToOpenSecondConnection = false;
  boolean secondTCPHandshakeToOpenSecondConnection = false;
  boolean thirdTCPHandshakeToOpenSecondConnection = false;
  boolean secondRequestReached = false;
  boolean secondResponseReached = false;
  boolean firstTCPHandshakeToCloseSecondConnection = false;
  boolean secondTCPHandshakeToCloseSecondConnection = false;
  boolean thirdTCPHandshakeToCloseSecondConnection = false;
  boolean string_11Removed = false;
  boolean string_12Removed = false;
  boolean string_13Removed = false;
  boolean string_14Removed = false;
  boolean string_15Removed = false;
  boolean string_16Removed = false;
  boolean string_17Removed = false;
  boolean string_18Removed = false;
  boolean string_19Removed = false;
  boolean string_20Removed = false;



  // Um auf andere Elemente des MainWindows zugreifen zu koennen
  MainWindow mW;







  // Konstruktor
  public NorthEastPanel( MainWindow mainWindow, HttpApplet httpApplet ) {


    mW = mainWindow;

 
    // Elemnete werden in der paint( Graphics g ) Methode in Abhaengigkeit 
    // der Groesse dises Panels gezeichnet.
    setLayout( null );


    // Buttons kreieren.
    startButton=new Button( "Start" );
    stopButton=new Button( "Stop" );
    resetButton=new Button( "Reset" );
    add( startButton );
    add( stopButton );
    add( resetButton );


    // Scrollbar um die Geschwindigkeit zu steuern
    slider = new Scrollbar( Scrollbar. HORIZONTAL, 2, 1, 1, 6 );
    add( slider );


    // Bilder fuer Client und Server holen.
    clientImage_1 = httpApplet. getImage( httpApplet. getCodeBase(), 
					  "../images/client_1.jpg" ); 
    clientImage_2 = httpApplet. getImage( httpApplet. getCodeBase(),
					  "../images/client_2.jpg" ); 
    serverImage = httpApplet. getImage( httpApplet. getCodeBase(),
					"../images/server.jpg" );


    // Load first the images fully
    tracker = new MediaTracker( this );
    tracker. addImage( serverImage, 0 );
    tracker. addImage( clientImage_1, 0 );
    tracker. addImage( clientImage_2, 0 );

    try {
      tracker. waitForAll();
    } catch ( InterruptedException e ) {
      return;
    }
    
  }




  // paint( Graphics g ) wird nach jedem Vergroessern des Fensters aufgerufen,
  // d.h. was man zum Zeitpunkt des Vergroessern des Fensters gezeichnet hat,
  // geht verloren, ( d.h. man muss es nochmal zeichnen und die respektiven
  // Groessen der Elemnet muessen aktuallisiert werden ).

  public void paint( Graphics g ) {


    // Alles in diesem Panel wird in Abhaengigkeit der Groesse des Panels
    // selbst ( 1/4 des Hauptpanels ) dargestellt ( Buttons sind 
    // 1/3 breit und 1/4 hoch; Bilder 2/7 breit, 1/2 hoch und 3/7 entfern;
    // TCP Connection Lines sind dann 3/7 lang ( - 2 Pixel an jeder  
    // Seite, damit sie nicht an den Client und Server Bilder dran sind ).
    

    // Fonts
    Font buttonsFont;
    Font sliderFont = new Font( "Helvetica", Font. PLAIN, 12);

    if ( size(). width < 300) {
	
      buttonsFont = new Font( "Helvetica", Font. PLAIN, 16);
      startButton. setFont( buttonsFont );
      stopButton. setFont( buttonsFont );
      resetButton. setFont( buttonsFont );
      
      sliderFont = new Font( "Helvetica", Font. PLAIN, 12);
    }
    
    if ( 300 <= size().width & size(). width < 400) {
      
      buttonsFont = new Font( "Helvetica", Font. PLAIN, 18);
      startButton. setFont( buttonsFont );
      stopButton. setFont( buttonsFont );
      resetButton. setFont( buttonsFont );

      sliderFont = new Font( "Helvetica", Font. PLAIN, 14);
    }
    
    if ( 400 <= size().width & size(). width < 500) {
      
      buttonsFont = new Font( "Helvetica", Font. PLAIN, 25);
      startButton. setFont( buttonsFont );
      stopButton. setFont( buttonsFont );
      resetButton. setFont( buttonsFont );
      
      sliderFont = new Font( "Helvetica", Font. PLAIN, 17);
    }
      
    if ( size().width >= 500 ) {
      
      buttonsFont = new Font( "Helvetica", Font. PLAIN, 25);      
      startButton. setFont( buttonsFont );
      stopButton. setFont( buttonsFont );
      resetButton. setFont( buttonsFont );
      
      sliderFont = new Font( "Helvetica", Font. PLAIN, 18);
    }
      

    
    // Buttons
    distance = 3;     // Platzabstand der Buttons und Bilder

    buttonsSpaceWidth = size(). width * 1/3;   // buttonsSpace- :
    buttonsSpaceHeight = size(). height * 1/5; // Platzhalter fuer Buttons.

    startButtonXPosition = distance;
    stopButtonXPosition = distance + buttonsSpaceWidth;
    resetButtonXPosition = distance + buttonsSpaceWidth * 2;
    
    buttonsYPosition = distance;
    
    buttonsWidth = buttonsSpaceWidth - distance * 2;
    buttonsHeight = buttonsSpaceHeight - distance * 2;
    
    startButton. reshape( startButtonXPosition, buttonsYPosition,
			  buttonsWidth, buttonsHeight );
    stopButton. reshape( stopButtonXPosition, buttonsYPosition,
			 buttonsWidth, buttonsHeight );
    resetButton. reshape( resetButtonXPosition, buttonsYPosition,
			  buttonsWidth, buttonsHeight );



    // Bilder
    imagesSpaceWidth = size(). width * 2/7;
    imagesSpaceHeight = size(). height * 3/5;
    distanceBetweenImages = size(). width * 3/7;

    clientImageXPosition = distance;
    serverImageXPosition = 
      imagesSpaceWidth + distanceBetweenImages + distance;
    
    imagesYPosition = buttonsSpaceHeight + distance;

    imagesWidth = imagesSpaceWidth - distance * 2;
    imagesHeight = imagesSpaceHeight - distance * 2;
    
    g. drawImage( serverImage,
		  serverImageXPosition, imagesYPosition,
		  imagesWidth, imagesHeight,
		  this );
    
    drawClientImage( clientImage_1 );




    // Slider
    int sliderWidth = distanceBetweenImages * 3/4;
    int sliderHeight = 15;
    int sliderXPosition = size(). width/2 - sliderWidth/2;
    int sliderYPosition = size(). height * 7/8 - 10;  

    slider. reshape( sliderXPosition, sliderYPosition,
		     sliderWidth, sliderHeight );

    g. setColor( Color. black );
    g. setFont( sliderFont );

    FontMetrics fontMetrics = g. getFontMetrics();

    g. drawString( "Slow",
		  sliderXPosition - fontMetrics. stringWidth( "Slow" )/2,
		  size(). height * 7/8 + fontMetrics. getAscent() + 10 );

    g. drawString( "Fast",
		  sliderXPosition + sliderWidth - 
		  fontMetrics. stringWidth( "Slow" )/2,
		  size(). height * 7/8 + fontMetrics. getAscent() + 10 );



    // TCP Connection Linien
    upperTCPConnectionLineXStart = imagesSpaceWidth + 2; 
    upperTCPConnectionLineYStart = 
      buttonsSpaceHeight + imagesSpaceHeight * 1/5; 
    
    lowerTCPConnectionLineXStart = upperTCPConnectionLineXStart; 
    lowerTCPConnectionLineYStart = 
      buttonsSpaceHeight + imagesSpaceHeight * 4/5; 
    
    connectionLength = distanceBetweenImages - 4;


    
    // Packet
    packetWidth = distanceBetweenImages * 2/10;
    packetHeight = imagesSpaceHeight * 1/10;
    packetXStart = imagesSpaceWidth;
    packetYPosition = size(). height * 1/2 - packetHeight * 1/2;
    actualPacketXPosition =
      packetXStart + ( distanceBetweenImages - packetWidth ) * porcentage/100;





    // Falls gestoppt wurde und Fenster vergroessert wurde
    clearTCPConnection();


    if ( start == true ) {

      // Falls Fenster vergroessert wurde, wenn Packet wandert, Packet in
      // aktueller Positionition neu zeichnen.
      if ( 5 < porcentage & porcentage < 95 ) {
	
	drawPacket();
      }
    }
    


    // Falls Fenster vergroessert wurde, in dem Moment als eins dieser
    // Strings geschrieben wurde, schreibe es noch mal.
    if ( firstTCPHandshakeToOpenFirstConnection == true & 
	 string_1Removed == false
	 |
	 firstTCPHandshakeToOpenSecondConnection == true & 
	 string_11Removed == false ) {
      
      drawString( "OPEN", "TCP CONNECTION", "REQUESTED" );
    }

    if ( secondTCPHandshakeToOpenFirstConnection == true & 
	 string_2Removed == false
	 |
	 secondTCPHandshakeToOpenSecondConnection == true & 
	 string_12Removed == false ) {
      
      drawString( "OPEN", "TCP CONNECTION", "ACKNOWLEDGED" );
    }

    if ( thirdTCPHandshakeToOpenFirstConnection == true &
	 thirdTCPHandshakeToCloseFirstConnection == false
	 |
	 thirdTCPHandshakeToOpenSecondConnection == true &
	 thirdTCPHandshakeToCloseSecondConnection == false ) {
      
      drawTCPConnection();
    }

    if ( thirdTCPHandshakeToOpenFirstConnection == true & 
	 string_3Removed == false
	 |
	 thirdTCPHandshakeToOpenSecondConnection == true & 
	 string_13Removed == false ) {
      
      drawString( "TCP CONNECTION", "ESTABLISHED ", "AND..." );
    }
	
    if ( string_3Removed == true & string_4Removed == false
	 |
	 string_13Removed == true & string_14Removed == false ) {
      
      drawString( " ...REQUEST   ",
		  "",
		  "    FOLLOWS..." );
    }

    if ( firstRequestReached == true & string_5Removed == false
	 |
	 secondRequestReached == true & string_15Removed == false ) {
      
      drawString( "   REQUEST   ",
		  "",
		  "   REACHED   " );
    }

    if ( firstResponseReached == true & string_6Removed == false
	 |
	 secondResponseReached == true & string_16Removed == false ) {
      
      drawString( "   RESPONSE  ",
		  "   REACHED   ",
		  "    AND...   " );
    }

    if ( string_6Removed == true & string_7Removed == false
	 |
	 string_16Removed == true & string_17Removed == false ) {
      
      drawString( "CLOSE", "TCP CONNECTION", "REQUEST FOLLOWS" );
    }

    if ( firstTCPHandshakeToCloseFirstConnection == true &
	 string_8Removed == false
	 |
	 firstTCPHandshakeToCloseSecondConnection == true &
	 string_18Removed == false ) {
      
      drawString( "CLOSE", "TCP CONNECTION", "REQUESTED" );
    }


    if ( secondTCPHandshakeToCloseFirstConnection == true &
	 string_9Removed == false
	 |
	 secondTCPHandshakeToCloseSecondConnection == true &
	 string_19Removed == false ) {
      
      drawString( "CLOSE", "TCP CONNECTION", "ACKNOWLEDGED" );
    }

    if ( thirdTCPHandshakeToCloseFirstConnection == true &
	 thirdTCPHandshakeToOpenSecondConnection == true ) {
      
      clearTCPConnection();
    }

    if ( thirdTCPHandshakeToCloseFirstConnection == true & 
	 string_10Removed == false
	 | 
	 thirdTCPHandshakeToCloseSecondConnection == true & 
	 string_20Removed == false ) {
      
      drawString( "TCP CONNECTION", "", "CLOSED" );
    }
  }
  




  // Zeichnet ein Packet
  public void drawPacket(){

    Graphics g = getGraphics();

    actualPacketXPosition = packetXStart + 
             ( distanceBetweenImages - packetWidth ) * porcentage/100;

    g. setColor( Color. black );
    
    g. drawRect( actualPacketXPosition,
		 packetYPosition,
		 packetWidth,
		 packetHeight );
  }




  //Schreibt alle Strings
  public void drawString( String string_1,
			  String string_2,
			  String string_3 ) {


    Graphics g = getGraphics();

    
    if ( size(). width < 300 ) {
      
      Font font = new Font( "Helvetica", Font. PLAIN, 10 );
      
      g. setFont( font );  
    }
      
    if ( 300 <= size(). width & size(). width < 400 ) {
      
      Font font = new Font( "Helvetica", Font. PLAIN, 12 );

      g. setFont( font );
    }
      
    if ( 400 <= size(). width & size(). width < 500 ) {
      
      Font font = new Font( "Helvetica", Font. PLAIN, 16 );
      
      g. setFont( font );
    }
    
    if ( 500 <= size(). width ) {
      
      Font font = new Font( "Helvetica", Font. PLAIN, 19 );
      
      g. setFont( font );  
    }
    
    
    FontMetrics fontMetrics = g. getFontMetrics();
    
    g. setColor( Color. red );
 
    g. drawString( string_1,

		   imagesSpaceWidth + distanceBetweenImages/2 - 
		   fontMetrics. stringWidth( string_1 )/2,

		   upperTCPConnectionLineYStart + 
		   ( lowerTCPConnectionLineYStart - 
		     upperTCPConnectionLineYStart ) / 3 * 1/2 +
		   fontMetrics. getAscent() * 1/2 );
    
    g. drawString( string_2,

		   imagesSpaceWidth + distanceBetweenImages/2 -
		   fontMetrics. stringWidth( string_2 )/2,

		   upperTCPConnectionLineYStart + 
		   ( lowerTCPConnectionLineYStart - 
		     upperTCPConnectionLineYStart ) / 3 +
		   ( lowerTCPConnectionLineYStart - 
		     upperTCPConnectionLineYStart ) / 3 * 1/2 +
		   fontMetrics. getAscent() * 1/2 );

    g. drawString( string_3,

		   imagesSpaceWidth + distanceBetweenImages/2 - 
		   fontMetrics. stringWidth( string_3 )/2,

		   upperTCPConnectionLineYStart + 
		   ( lowerTCPConnectionLineYStart - 
		     upperTCPConnectionLineYStart ) * 2/3 +
		   ( lowerTCPConnectionLineYStart - 
		     upperTCPConnectionLineYStart ) / 3 * 1/2 +
		   fontMetrics. getAscent() * 1/2 );

  }




  // Es gibt zwei client Bilder. 
  // Diese Funktion wird auch von ausserhalb aufgerufen. 
  public void drawClientImage( Image clientImage ) {


    Graphics g = getGraphics();

    g. drawImage( clientImage, clientImageXPosition, imagesYPosition,
		 imagesWidth, imagesHeight, this );
  }







  // TCP Connection Linien zeichnen
  public void drawTCPConnection() {

    Graphics g = getGraphics();

    g. setColor( Color. black );
    
    g. drawLine( upperTCPConnectionLineXStart,
		 upperTCPConnectionLineYStart,
		 upperTCPConnectionLineXStart + connectionLength, 
		 upperTCPConnectionLineYStart );
    
    g. drawLine( lowerTCPConnectionLineXStart,
		 lowerTCPConnectionLineYStart,
		 lowerTCPConnectionLineXStart + connectionLength, 
		 lowerTCPConnectionLineYStart );
  }




  // Hier wird zwischen dem Client und Server Bild ein Rechteck mit der
  // Hintergrunfaerbe gezeichnet ( aber nicht so hoch ), so dass alles
  // was zwischen den TCP Connection Lines gezeichnet wurde geloescht wird
  // ( Um die Strings zu loeschen )
  public void clearString() {

    Graphics g = getGraphics();

    g. clearRect( imagesSpaceWidth,
		  upperTCPConnectionLineYStart + 2,
		  distanceBetweenImages,
		  lowerTCPConnectionLineYStart - upperTCPConnectionLineYStart - 4 );
  }



  // Loescht jedes mal Packet
  public void clearPacket() {

    Graphics g = getGraphics();

    g. clearRect( imagesSpaceWidth + 1, packetYPosition - 1,
		  distanceBetweenImages - 2 , packetHeight + 2 );
  }


  // Hier wird zwischen dem Client und Server Bild ein Rechteck mit der
  // Hintergrunfaerbe gezeichnet, so dass alles gezeichnete geloescht wird
  public void clearTCPConnection() {

    Graphics g = getGraphics();
    
    g. clearRect( imagesSpaceWidth + 1, buttonsSpaceHeight + 1,
		  distanceBetweenImages - 2, imagesSpaceHeight - 2 );
  }

  


  // Eventhaendler fuer die Buttons
  public boolean action( Event e, Object arg ) {

    if ( e. target == startButton ) {
      
      if ( start == false ) {
	
	start = true;

 	drawClientImage( clientImage_2 );


	mW. southPanel. historyPanel. repaint();



	stopFlowControlThread = false;
	flowControlThread = new FlowControlThread( mW );
	flowControlThread. start();

	return true;
      }
    }
    else if ( e. target ==  stopButton ) {
      
      if ( stopButton. getLabel(). equals( "Stop" ) ) {
	
	if ( start ) {

	  drawClientImage( clientImage_1 );

	  stopButton. setLabel( "Weiter" );

	  stopFlowControlThread = true;

 	  stopLabelThread = false;
	  stopButtonLabelThread = new ButtonLabelThread( this );
	  stopButtonLabelThread. start();
	  
	  return true;
	}
      }
      else if ( stopButton. getLabel(). equals( "Weiter" ) ) {

	stopButton. setLabel( "Stop" );

	stopLabelThread = true;

	stopFlowControlThread = false;
	flowControlThread = new FlowControlThread( mW );
	flowControlThread. start();

	return true;
      }
    }
    else if ( e. target ==  resetButton ) {

      if ( stopButton. getLabel(). equals( "Weiter" ) ) {

	stopLabelThread = true;

	stopButton. setLabel( "Stop" );
      }

      clearTCPConnection();
      drawClientImage( clientImage_1 );

      mW. northWestPanel. htmlEditor. replaceText( "", 0, 1000 );

      mW. southPanel. scrollbar. setValue( 0 ); 
      mW. southPanel. historyPanel. ty =
	mW. southPanel. scrollbar. getValue(); 
      mW. southPanel. historyPanel. repaint();

      
      stopFlowControlThread = true;

      start = false;
      porcentage = 0;
      timeCounter = 0;

      firstTCPHandshakeToOpenFirstConnection = false;
      secondTCPHandshakeToOpenFirstConnection = false;
      thirdTCPHandshakeToOpenFirstConnection = false;
      firstRequestReached = false;
      firstResponseReached = false;
      firstTCPHandshakeToCloseFirstConnection = false;
      secondTCPHandshakeToCloseFirstConnection = false;
      thirdTCPHandshakeToCloseFirstConnection = false;
      string_1Removed = false;
      string_2Removed = false;
      string_3Removed = false;
      string_4Removed = false;
      string_5Removed = false;
      string_6Removed = false;
      string_7Removed = false;
      string_8Removed = false;
      string_9Removed = false;
      string_10Removed = false;
      
      firstTCPHandshakeToOpenSecondConnection = false;
      secondTCPHandshakeToOpenSecondConnection = false;
      thirdTCPHandshakeToOpenSecondConnection = false;
      secondRequestReached = false;
      secondResponseReached = false;
      firstTCPHandshakeToCloseSecondConnection = false;
      secondTCPHandshakeToCloseSecondConnection = false;
      thirdTCPHandshakeToCloseSecondConnection = false;
      string_11Removed = false;
      string_12Removed = false;
      string_13Removed = false;
      string_14Removed = false;
      string_15Removed = false;
      string_16Removed = false;
      string_17Removed = false;
      string_18Removed = false;
      string_19Removed = false;
      string_20Removed = false;
      
      return true;
    }

    return false;
  }


}
